//
// (c) 2025 wesolutions GmbH
// All rights reserved.
//

import QtQml 2.12
import QtQuick 2.12

import wesual.Ui 1.0

FocusScope {
    id : uiColorEdit

    signal editingFinished()

    property color color
    property bool readOnly
    property bool indeterminate : false

    readonly property alias hovered : textEdit.hovered

    signal updateRequested(color newValue)

    implicitWidth : 104
    implicitHeight : textEdit.implicitHeight
    activeFocusOnTab : true
    baselineOffset : textEdit.baselineOffset

    UiLineEdit {
        id : textEdit

        function commitEdit(text) {
            if (!textEdit.acceptableInput)
                return;

            if (text[0] !== '#') {
                text = '#' + text;
            }

            uiColorEdit.updateRequested(text);
        }

        anchors.fill : parent
        rightPadding : button.width + 4
        focus : true
        minimumWidth : 104
        validator : RegExpValidator {
            regExp: /^\#?(?:[0-9a-f]{3})(?:[0-9a-f]{3})?$/i
        }

        bindable : true
        text : {
            if (!indeterminate) {
                return uiColorEdit.color.toString().toUpperCase();
            } else {
                return "";
            }
        }

        readOnly : uiColorEdit.readOnly

        onUpdateRequested : commitEdit(newValue)
        onEditingFinished : uiColorEdit.editingFinished()
    }

    UiToolButton {
        id : button

        anchors {
            right : parent.right
            top : parent.top
            bottom : parent.bottom
        }
        width : height - 1
        z : 1
        down : popup.popupVisible
        enabled : !uiColorEdit.readOnly

        onClicked : popup.show()
    }

    Rectangle {
        width : 18
        height : 18
        color : uiColorEdit.color
        anchors.centerIn : button
        visible : !uiColorEdit.indeterminate
        z : 2

        border {
            width : 1
            color : "#10000000"
        }
    }

    UiIcon {
        anchors.centerIn : button
        iconName : "indeterminate-color"
        disabled : !uiColorEdit.enabled ? 1 : 0
        visible : uiColorEdit.indeterminate
        z : 2
    }

    UiPopupEditor {
        id : popup

        anchors.centerIn : button

        padding : 6
        verticalOffset : button.height / 2 + 4
        triggerItem : button
        component : UiColorPicker {
            indeterminate : uiColorEdit.indeterminate
            bindable : true
            color : uiColorEdit.color

            onUpdateRequested : uiColorEdit.updateRequested(newValue)
        }
    }
}
